#include <ze_vip>

// Variables
new g_szPasswordKey[65], g_szPassword[65]
new bool:g_bIsUserVIP[33], bool:g_bSetVIP[33], g_iFlags[33], bool:g_bIsHappyHour

// Const.
static const COLOR[] = "^x04"
static const g_szLocalFile[] = "addons/amxmodx/configs/ze_vips.ini"

new const szCommands[][] =
{
	"say /vip",
	"say /vips",
	"say_team /vip",
	"say_team /vips"
}

// Cvars
new Cvar_Show_VIP_Scoreboard, Cvar_Give_Multijump, Cvar_Connect_Message, Cvar_Admin_Contact,
Cvar_Give_Parachute, Cvar_Enable_Happy_Hours, Cvar_Happy_Hour_Start, Cvar_Happy_Hour_End,
Cvar_VIP_Flag

public plugin_natives()
{
	register_native("ze_get_vip_flags", "native_ze_get_vip_flags", 1)
	register_native("ze_set_vip_flags", "native_ze_set_vip_flags", 1)
}

public plugin_init()
{
	register_plugin("[ZE] Zombie Escape VIP", VIP_VERSION, AUTHORS)
	
	// Hook Chains
	RegisterHookChain(RG_CBasePlayer_Spawn, "Fw_PlayerSpawn_Post", 1)
	
	// Cvars
	Cvar_Connect_Message = register_cvar("ze_connect_message", "1")
	Cvar_Admin_Contact = register_cvar("ze_admin_contact", "Admin Name")
	Cvar_Give_Multijump = register_cvar("ze_give_vip_multijump", "1")
	Cvar_Show_VIP_Scoreboard = register_cvar("ze_show_vip_scoreboard", "1")
	Cvar_Give_Parachute = register_cvar("ze_give_vip_parachute", "1")
	Cvar_Enable_Happy_Hours = register_cvar("ze_enable_happy_hours", "1")
	Cvar_Happy_Hour_Start = register_cvar("ze_happy_hours_start", "9")
	Cvar_Happy_Hour_End = register_cvar("ze_happy_hours_end", "12")
	Cvar_VIP_Flag = register_cvar("ze_happy_hours_vip_flags", "abcd")
	
	register_cvar("ze_vip_version", VIP_VERSION, FCVAR_SERVER|FCVAR_SPONLY)
	set_cvar_string("ze_vip_version", VIP_VERSION)
	
	// Commands
	for (new i = 0; i < charsmax(szCommands); i++)
		register_clcmd(szCommands[i], "CmdVIP")

	register_clcmd("say /getvip", "CmdMotd")
	register_clcmd("say_team /getvip", "CmdMotd")
	
	// Get Password Key
	get_cvar_string("amx_password_field", g_szPasswordKey, charsmax(g_szPasswordKey))
	
	// Initialize Arrays
	arrayset(g_bIsUserVIP, false, 32)
	arrayset(g_bSetVIP, false, 32)
}

public plugin_cfg()
{
	// Get our configiration file and Execute it
	new szCfgDir[64]
	get_localinfo("amxx_configsdir", szCfgDir, charsmax(szCfgDir))
	server_cmd("exec %s/ze_vip.cfg", szCfgDir)
}

public client_authorized(id)
{
	// Get password from Setinfo
	new szPassword[65]
	get_user_info(id, g_szPasswordKey, szPassword, charsmax(szPassword))
	
	// Player VIP?
	ze_get_vip_flags(id)
	
	if (g_bIsUserVIP[id])
	{
		if (!equal(szPassword, g_szPassword))
		{
			// VIP-nak ha hibás a jelszó? Kirúgja a szerver
			client_cmd(id, "echo ^"* VIP hibás jelszó!^"")
			server_cmd("kick #%d ^"Nincs bejegyzésed a szerveren...^"", get_user_userid(id))
		}
		else
		{
			client_cmd(id, "echo ^"* VIP jelszó elfogadva!^"")
		}
	}
}

public client_putinserver(id)
{
	if (ze_get_vip_flags(id) & VIP_A)
	{
		if (get_pcvar_num(Cvar_Connect_Message) != 0)
		{
			new szName[32]
			get_user_name(id, szName, charsmax(szName))
			ze_colored_print(0, "!tVIP !g%s !tcsatlakozott a szerverre!y.", szName)
		}
	}
}

public CmdMotd(id)
{
	show_motd(id, "ze_vip.txt", "Zombie Escape VIP")
}

public CmdVIP(id)
{
	set_task(0.1, "Print_VIP_Names", id)
}

public Print_VIP_Names(id)
{
	new szAdminName[33][32], szMessage[256]
	new szContactInfo[256], szContact[112]
	new id, iCount, x, iLen
	
	for (id = 1 ; id <= get_member_game(m_nMaxPlayers) ; id++)
	{
		if (is_user_connected(id) && (ze_get_vip_flags(id) & VIP_A))
		{
			get_user_name(id, szAdminName[iCount++], charsmax(szAdminName))
		}

		iLen = format(szMessage, charsmax(szMessage), "%s Jelenlévő VIP: ", COLOR)
		
		if (iCount > 0)
		{
			for (x = 0 ; x < iCount ; x++)
			{
				iLen += format(szMessage[iLen], charsmax(szMessage) - iLen, "%s%s ", szAdminName[x], x < (iCount - 1) ? ", " : "")
				
				if (iLen > 96 )
				{
					print_message(id, szMessage)
					iLen = format(szMessage, charsmax(szMessage), "%s ", COLOR)
				}
			}
			
			print_message(id, szMessage)
		}
		else
		{
			iLen += format(szMessage[iLen], charsmax(szMessage) - iLen, "Nincsenek elérhető VIP-ek.")
			print_message(id, szMessage)
		}
		
		get_pcvar_string(Cvar_Admin_Contact, szContact, charsmax(szContact))
		
		if (szContact[0])
		{
			format(szContactInfo, charsmax(szContactInfo), "%s- Kapcsolat a Szerver Tulajdonossal -- %s", COLOR, szContact)
			print_message(id, szContactInfo)
		}
	}
}

public Fw_PlayerSpawn_Post(id)
{
	if (!is_user_alive(id))
		return
	
	Happy_Hours()
	
	if (g_bIsHappyHour == true && get_pcvar_num(Cvar_Enable_Happy_Hours) != 0)
	{
		new szFlags[VIP_MAX_FLAGS]
		get_pcvar_string(Cvar_VIP_Flag, szFlags, charsmax(szFlags))
		ze_set_vip_flags(id, read_flags(szFlags))
	}
	
	// Get password from Setinfo
	new szPassword[65]
	get_user_info(id, g_szPasswordKey, szPassword, charsmax(szPassword))
	
	ze_get_vip_flags(id)
	
	if (g_bIsUserVIP[id])
	{
		if (!equal(szPassword, g_szPassword))
		{
			// VIP ha hibás a jelszó? Kirúgja a szerver
			client_cmd(id, "echo ^"* VIP Hibás Jelszó!^"")
			server_cmd("kick #%d ^"Nincs bejegyzésed a szerveren...^"", get_user_userid(id))
		}
		else
		{
			client_cmd(id, "echo ^"* VIP Jelszó Elfogadva!^"")
		}
	}
	
	if (ze_get_vip_flags(id) & VIP_B)
	{
		if (get_pcvar_num(Cvar_Give_Multijump) != 0)
		{
			ze_give_user_multijump(id)
		}
	}
	
	if (ze_get_vip_flags(id) & VIP_C)
	{
		if (get_pcvar_num(Cvar_Give_Parachute) != 0)
		{
			ze_give_user_parachute(id)
		}
	}

	set_task(0.1, "Update_Attribute", id, _, _, "a", 10)
}

public ze_roundend(WinTeam)
{
	for (new i = 0; i < get_member_game(m_nMaxPlayers); i++)
	{
		g_bSetVIP[i] = false
	}
}

public Update_Attribute(id)
{
	if ((ze_get_vip_flags(id) & VIP_D) && get_pcvar_num(Cvar_Show_VIP_Scoreboard) != 0)
	{
		message_begin(MSG_ALL, get_user_msgid("ScoreAttrib"), {0, 0, 0}, id)
		write_byte(id)
		write_byte(4)
		message_end()
	}
}

public native_ze_get_vip_flags(id)
{
	if (file_exists(g_szLocalFile))
	{
		new iMaxLines = file_size(g_szLocalFile, 1)
		new szLineToRead[129]
		new szSteamID[35], szName[32]
		new szParse[3][65]
		new iTextLen
		
		get_user_authid(id, szSteamID, charsmax(szSteamID))
		get_user_name(id, szName, charsmax(szName))
		
		for (new iLineToRead = 0; iLineToRead < iMaxLines; iLineToRead++)
		{
			read_file(g_szLocalFile, iLineToRead, szLineToRead, charsmax(szLineToRead), iTextLen)
			parse(szLineToRead, szParse[0], 64, szParse[1], 64, szParse[2], 64)
			
			remove_quotes(szParse[0])
			remove_quotes(szParse[1])
			remove_quotes(szParse[2])
			
			if (!szParse[0][0] || szParse[0][0] == ';' || (szParse[0][0] == '/' && szParse[0][1] == '/'))
				continue
			
			if ((equali(szSteamID, szParse[0]) && szParse[0][0] == 'S') || equali(szName, szParse[0]))
			{
				g_bIsUserVIP[id] = true
				copy(g_szPassword, charsmax(g_szPassword), szParse[1])

				return read_flags(szParse[2])
			}
		}
	}
	else
	{
		write_file(g_szLocalFile, "; Zombie Escape VIP^n^n;Jogok:^n")
		write_file(g_szLocalFile, "; a -- Csatlakozó Üzenet, és VIP listán megjelenik")
		write_file(g_szLocalFile, "; b -- Többszöri Ugrás")
		write_file(g_szLocalFile, "; c -- Ejtőernyő")
		write_file(g_szLocalFile, "; d -- Megjelenik az eredmény jelzőn.^n^n;Példák:^n")
		write_file(g_szLocalFile, "; ^"Steam/Név^" ^"Jelszó^" ^"Jogok^"")
	}
	
	g_bIsUserVIP[id] = false
	
	if (g_bSetVIP[id] == true)
	{
		return g_iFlags[id]
	}
	else
	{
		return VIP_Z
	}
	
	return VIP_Z
}

public native_ze_set_vip_flags(id, Flags)
{
	g_bSetVIP[id] = true
	g_iFlags[id] = Flags
	ze_get_vip_flags(id)
}

stock Happy_Hours()
{
	new szTime[3]
	get_time("%H", szTime, charsmax(szTime))

	if(get_pcvar_num(Cvar_Happy_Hour_End) > str_to_num(szTime) >= get_pcvar_num(Cvar_Happy_Hour_Start))
	{
        g_bIsHappyHour = true
	}
	else
	{
		g_bIsHappyHour = false
	}
}

stock print_message(id, msg[])
{
	message_begin(MSG_ONE, get_user_msgid("SayText"), {0,0,0}, id)
	write_byte(id)
	write_string(msg)
	message_end()
}